/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, object, optional, Schema, string } from '../schema';
import { LinkDescription, linkDescriptionSchema } from './linkDescription';
import { VaultCustomer, vaultCustomerSchema } from './vaultCustomer';
import { VaultStatus, vaultStatusSchema } from './vaultStatus';

/** The details about a saved payment source. */
export interface VaultResponse {
  /** The PayPal-generated ID for the saved payment source. */
  id?: string;
  /** The vault status. */
  status?: VaultStatus;
  /** This object represents a merchant’s customer, allowing them to store contact details, and track all payments associated with the same customer. */
  customer?: VaultCustomer;
  /** An array of request-related HATEOAS links. */
  links?: LinkDescription[];
}

export const vaultResponseSchema: Schema<VaultResponse> = object({
  id: ['id', optional(string())],
  status: ['status', optional(vaultStatusSchema)],
  customer: ['customer', optional(lazy(() => vaultCustomerSchema))],
  links: ['links', optional(array(lazy(() => linkDescriptionSchema)))],
});
