/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { lazy, object, optional, Schema, string } from '../schema';
import {
  ExperienceContext,
  experienceContextSchema,
} from './experienceContext';

/** Information needed to pay using Trustly. */
export interface TrustlyPaymentRequest {
  /** The full name representation like Mr J Smith. */
  name: string;
  /** The [two-character ISO 3166-1 code](/api/rest/reference/country-codes/) that identifies the country or region. Note: The country code for Great Britain is GB and not UK as used in the top-level domain names for that country. Use the `C2` country code for China worldwide for comparable uncontrolled price (CUP) method, bank card, and cross-border transactions. */
  countryCode: string;
  /** The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters are allowed after the @ sign. However, the generally accepted maximum length for an email address is 254 characters. The pattern verifies that an unquoted @ sign exists. */
  email: string;
  /** Customizes the payer experience during the approval process for the payment. */
  experienceContext?: ExperienceContext;
}

export const trustlyPaymentRequestSchema: Schema<TrustlyPaymentRequest> = object(
  {
    name: ['name', string()],
    countryCode: ['country_code', string()],
    email: ['email', string()],
    experienceContext: [
      'experience_context',
      optional(lazy(() => experienceContextSchema)),
    ],
  }
);
