/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import {
  array,
  lazy,
  object,
  optional,
  Schema,
  string,
  unknown,
} from '../schema';
import { BillingCycle, billingCycleSchema } from './billingCycle';
import { OneTimeCharge, oneTimeChargeSchema } from './oneTimeCharge';

/** The merchant level Recurring Billing plan metadata for the Billing Agreement. */
export interface Plan {
  /** An array of billing cycles for trial billing and regular billing. A plan can have at most two trial cycles and only one regular cycle. */
  billingCycles: BillingCycle[];
  /** Product details associated with any one-time product purchase. */
  product?: unknown;
  /** The one-time charge info at the time of checkout. */
  oneTimeCharges: OneTimeCharge;
  /** Name of the recurring plan. */
  name?: string;
}

export const planSchema: Schema<Plan> = object({
  billingCycles: ['billing_cycles', array(lazy(() => billingCycleSchema))],
  product: ['product', optional(unknown())],
  oneTimeCharges: ['one_time_charges', lazy(() => oneTimeChargeSchema)],
  name: ['name', optional(string())],
});
