/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, object, optional, Schema } from '../schema';
import { CobrandedCard, cobrandedCardSchema } from './cobrandedCard';
import {
  PaypalWalletVaultResponse,
  paypalWalletVaultResponseSchema,
} from './paypalWalletVaultResponse';

/** Additional attributes associated with the use of a PayPal Wallet. */
export interface PaypalWalletAttributesResponse {
  /** The details about a saved PayPal Wallet payment source. */
  vault?: PaypalWalletVaultResponse;
  /** An array of merchant cobranded cards used by buyer to complete an order. This array will be present if a merchant has onboarded their cobranded card with PayPal and provided corresponding label(s). */
  cobrandedCards?: CobrandedCard[];
}

export const paypalWalletAttributesResponseSchema: Schema<PaypalWalletAttributesResponse> = object(
  {
    vault: ['vault', optional(lazy(() => paypalWalletVaultResponseSchema))],
    cobrandedCards: [
      'cobranded_cards',
      optional(array(lazy(() => cobrandedCardSchema))),
    ],
  }
);
