/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { lazy, object, optional, Schema, string } from '../schema';
import { Address, addressSchema } from './address';
import { Name, nameSchema } from './name';
import {
  PaypalWalletAttributes,
  paypalWalletAttributesSchema,
} from './paypalWalletAttributes';
import {
  PaypalWalletExperienceContext,
  paypalWalletExperienceContextSchema,
} from './paypalWalletExperienceContext';
import {
  PaypalWalletStoredCredential,
  paypalWalletStoredCredentialSchema,
} from './paypalWalletStoredCredential';
import { PhoneWithType, phoneWithTypeSchema } from './phoneWithType';
import { TaxInfo, taxInfoSchema } from './taxInfo';

/** A resource that identifies a PayPal Wallet is used for payment. */
export interface PaypalWallet {
  /** The PayPal-generated ID for the vaulted payment source. This ID should be stored on the merchant's server so the saved payment source can be used for future transactions. */
  vaultId?: string;
  /** The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters are allowed after the @ sign. However, the generally accepted maximum length for an email address is 254 characters. The pattern verifies that an unquoted @ sign exists. */
  emailAddress?: string;
  /** The name of the party. */
  name?: Name;
  /** The phone information. */
  phone?: PhoneWithType;
  /** The stand-alone date, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.6). To represent special legal values, such as a date of birth, you should use dates with no associated time or time-zone data. Whenever possible, use the standard `date_time` type. This regular expression does not validate all dates. For example, February 31 is valid and nothing is known about leap years. */
  birthDate?: string;
  /** The tax ID of the customer. The customer is also known as the payer. Both `tax_id` and `tax_id_type` are required. */
  taxInfo?: TaxInfo;
  /** The portable international postal address. Maps to [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling form controls: the autocomplete attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute). */
  address?: Address;
  /** Additional attributes associated with the use of this PayPal Wallet. */
  attributes?: PaypalWalletAttributes;
  /** Customizes the payer experience during the approval process for payment with PayPal. Note: Partners and Marketplaces might configure brand_name and shipping_preference during partner account setup, which overrides the request values. */
  experienceContext?: PaypalWalletExperienceContext;
  /** The PayPal billing agreement ID. References an approved recurring payment for goods or services. */
  billingAgreementId?: string;
  /** Provides additional details to process a payment using the PayPal wallet billing agreement or a vaulted payment method that has been stored or is intended to be stored. */
  storedCredential?: PaypalWalletStoredCredential;
}

export const paypalWalletSchema: Schema<PaypalWallet> = object({
  vaultId: ['vault_id', optional(string())],
  emailAddress: ['email_address', optional(string())],
  name: ['name', optional(lazy(() => nameSchema))],
  phone: ['phone', optional(lazy(() => phoneWithTypeSchema))],
  birthDate: ['birth_date', optional(string())],
  taxInfo: ['tax_info', optional(lazy(() => taxInfoSchema))],
  address: ['address', optional(lazy(() => addressSchema))],
  attributes: [
    'attributes',
    optional(lazy(() => paypalWalletAttributesSchema)),
  ],
  experienceContext: [
    'experience_context',
    optional(lazy(() => paypalWalletExperienceContextSchema)),
  ],
  billingAgreementId: ['billing_agreement_id', optional(string())],
  storedCredential: [
    'stored_credential',
    optional(lazy(() => paypalWalletStoredCredentialSchema)),
  ],
});
