/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { object, optional, Schema } from '../schema';
import { AvsCode, avsCodeSchema } from './avsCode';
import { CvvCode, cvvCodeSchema } from './cvvCode';
import {
  PaymentsPaymentAdviceCode,
  paymentsPaymentAdviceCodeSchema,
} from './paymentsPaymentAdviceCode';
import {
  ProcessorResponseCode,
  processorResponseCodeSchema,
} from './processorResponseCode';

/** The processor response information for payment requests, such as direct credit card transactions. */
export interface PaymentsProcessorResponse {
  /** The address verification code for Visa, Discover, Mastercard, or American Express transactions. */
  avsCode?: AvsCode;
  /** The card verification value code for for Visa, Discover, Mastercard, or American Express. */
  cvvCode?: CvvCode;
  /** Processor response code for the non-PayPal payment processor errors. */
  responseCode?: ProcessorResponseCode;
  /** The declined payment transactions might have payment advice codes. The card networks, like Visa and Mastercard, return payment advice codes. */
  paymentAdviceCode?: PaymentsPaymentAdviceCode;
}

export const paymentsProcessorResponseSchema: Schema<PaymentsProcessorResponse> = object(
  {
    avsCode: ['avs_code', optional(avsCodeSchema)],
    cvvCode: ['cvv_code', optional(cvvCodeSchema)],
    responseCode: ['response_code', optional(processorResponseCodeSchema)],
    paymentAdviceCode: [
      'payment_advice_code',
      optional(paymentsPaymentAdviceCodeSchema),
    ],
  }
);
