/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, object, optional, Schema } from '../schema';
import {
  AuthorizationWithAdditionalData,
  authorizationWithAdditionalDataSchema,
} from './authorizationWithAdditionalData';
import { OrdersCapture, ordersCaptureSchema } from './ordersCapture';
import { Refund, refundSchema } from './refund';

/** The collection of payments, or transactions, for a purchase unit in an order. For example, authorized payments, captured payments, and refunds. */
export interface PaymentCollection {
  /** An array of authorized payments for a purchase unit. A purchase unit can have zero or more authorized payments. */
  authorizations?: AuthorizationWithAdditionalData[];
  /** An array of captured payments for a purchase unit. A purchase unit can have zero or more captured payments. */
  captures?: OrdersCapture[];
  /** An array of refunds for a purchase unit. A purchase unit can have zero or more refunds. */
  refunds?: Refund[];
}

export const paymentCollectionSchema: Schema<PaymentCollection> = object({
  authorizations: [
    'authorizations',
    optional(array(lazy(() => authorizationWithAdditionalDataSchema))),
  ],
  captures: ['captures', optional(array(lazy(() => ordersCaptureSchema)))],
  refunds: ['refunds', optional(array(lazy(() => refundSchema)))],
});
