/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, object, optional, Schema, string } from '../schema';
import {
  OrderUpdateCallbackShippingAddress,
  orderUpdateCallbackShippingAddressSchema,
} from './orderUpdateCallbackShippingAddress';
import {
  OrderUpdateCallbackShippingOption,
  orderUpdateCallbackShippingOptionSchema,
} from './orderUpdateCallbackShippingOption';
import {
  PurchaseUnitRequest,
  purchaseUnitRequestSchema,
} from './purchaseUnitRequest';

/** Shipping Options Callback request. This will be implemented by the merchants. */
export interface OrderUpdateCallbackRequest {
  /** The ID of the order. */
  id?: string;
  /** The portable international postal address. Maps to [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling form controls: the autocomplete attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute). */
  shippingAddress: OrderUpdateCallbackShippingAddress;
  /** The options that the payee or merchant offers to the payer to ship or pick up their items. */
  shippingOption?: OrderUpdateCallbackShippingOption;
  /** An array of purchase units. At present only 1 purchase_unit is supported. Each purchase unit establishes a contract between a payer and the payee. Each purchase unit represents either a full or partial order that the payer intends to purchase from the payee. */
  purchaseUnits: PurchaseUnitRequest[];
}

export const orderUpdateCallbackRequestSchema: Schema<OrderUpdateCallbackRequest> = object(
  {
    id: ['id', optional(string())],
    shippingAddress: [
      'shipping_address',
      lazy(() => orderUpdateCallbackShippingAddressSchema),
    ],
    shippingOption: [
      'shipping_option',
      optional(lazy(() => orderUpdateCallbackShippingOptionSchema)),
    ],
    purchaseUnits: [
      'purchase_units',
      array(lazy(() => purchaseUnitRequestSchema)),
    ],
  }
);
