/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, object, optional, Schema, string } from '../schema';
import { BillingCycle, billingCycleSchema } from './billingCycle';
import { Money, moneySchema } from './money';

/** Metadata for merchant-managed recurring billing plans. Valid only during the saved payment method token or billing agreement creation. */
export interface OrderBillingPlan {
  /** An array of billing cycles for trial billing and regular billing. A plan can have at most two trial cycles and only one regular cycle. */
  billingCycles: BillingCycle[];
  /** The currency and amount for a financial transaction, such as a balance or payment due. */
  setupFee?: Money;
  /** Name of the recurring plan. */
  name?: string;
}

export const orderBillingPlanSchema: Schema<OrderBillingPlan> = object({
  billingCycles: ['billing_cycles', array(lazy(() => billingCycleSchema))],
  setupFee: ['setup_fee', optional(lazy(() => moneySchema))],
  name: ['name', optional(string())],
});
