/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { lazy, object, optional, Schema, string } from '../schema';
import { Name, nameSchema } from './name';
import { PhoneWithType, phoneWithTypeSchema } from './phoneWithType';

/** This object represents a merchant’s customer, allowing them to store contact details, and track all payments associated with the same customer. */
export interface CustomerInformation {
  /** The unique ID for a customer generated by PayPal. */
  id?: string;
  /** The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters are allowed after the @ sign. However, the generally accepted maximum length for an email address is 254 characters. The pattern verifies that an unquoted @ sign exists. */
  emailAddress?: string;
  /** The phone information. */
  phone?: PhoneWithType;
  /** The name of the party. */
  name?: Name;
}

export const customerInformationSchema: Schema<CustomerInformation> = object({
  id: ['id', optional(string())],
  emailAddress: ['email_address', optional(string())],
  phone: ['phone', optional(lazy(() => phoneWithTypeSchema))],
  name: ['name', optional(lazy(() => nameSchema))],
});
