/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { lazy, object, optional, Schema } from '../schema';
import {
  OrderConfirmApplicationContext,
  orderConfirmApplicationContextSchema,
} from './orderConfirmApplicationContext';
import { PaymentSource, paymentSourceSchema } from './paymentSource';

/** Payer confirms the intent to pay for the Order using the provided payment source. */
export interface ConfirmOrderRequest {
  /** The payment source definition. */
  paymentSource: PaymentSource;
  /** Customizes the payer confirmation experience. */
  applicationContext?: OrderConfirmApplicationContext;
}

export const confirmOrderRequestSchema: Schema<ConfirmOrderRequest> = object({
  paymentSource: ['payment_source', lazy(() => paymentSourceSchema)],
  applicationContext: [
    'application_context',
    optional(lazy(() => orderConfirmApplicationContextSchema)),
  ],
});
