/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { lazy, object, optional, Schema, string } from '../schema';
import { BinDetails, binDetailsSchema } from './binDetails';
import {
  CardAuthenticationResponse,
  cardAuthenticationResponseSchema,
} from './cardAuthenticationResponse';
import { CardBrand, cardBrandSchema } from './cardBrand';
import {
  CardResponseAddress,
  cardResponseAddressSchema,
} from './cardResponseAddress';
import { CardType, cardTypeSchema } from './cardType';
import {
  CardVerificationDetails,
  cardVerificationDetailsSchema,
} from './cardVerificationDetails';
import {
  CardVerificationStatus,
  cardVerificationStatusSchema,
} from './cardVerificationStatus';
import {
  NetworkTransactionReferenceEntity,
  networkTransactionReferenceEntitySchema,
} from './networkTransactionReferenceEntity';

/** Full representation of a Card Payment Token. */
export interface CardPaymentTokenEntity {
  /** The card holder's name as it appears on the card. */
  name?: string;
  /** The last digits of the payment card. */
  lastDigits?: string;
  /** The card network or brand. Applies to credit, debit, gift, and payment cards. */
  brand?: CardBrand;
  /** The year and month, in ISO-8601 `YYYY-MM` date format. See [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.6). */
  expiry?: string;
  /** Address request details. */
  billingAddress?: CardResponseAddress;
  /** Verification status of Card. */
  verificationStatus?: CardVerificationStatus;
  /** Card Verification details including the authorization details and 3D SECURE details. */
  verification?: CardVerificationDetails;
  /** Previous network transaction reference including id in response. */
  networkTransactionReference?: NetworkTransactionReferenceEntity;
  /** Results of Authentication such as 3D Secure. */
  authenticationResult?: CardAuthenticationResponse;
  /** Bank Identification Number (BIN) details used to fund a payment. */
  binDetails?: BinDetails;
  /** Type of card. i.e Credit, Debit and so on. */
  type?: CardType;
}

export const cardPaymentTokenEntitySchema: Schema<CardPaymentTokenEntity> = object(
  {
    name: ['name', optional(string())],
    lastDigits: ['last_digits', optional(string())],
    brand: ['brand', optional(cardBrandSchema)],
    expiry: ['expiry', optional(string())],
    billingAddress: [
      'billing_address',
      optional(lazy(() => cardResponseAddressSchema)),
    ],
    verificationStatus: [
      'verification_status',
      optional(cardVerificationStatusSchema),
    ],
    verification: [
      'verification',
      optional(lazy(() => cardVerificationDetailsSchema)),
    ],
    networkTransactionReference: [
      'network_transaction_reference',
      optional(lazy(() => networkTransactionReferenceEntitySchema)),
    ],
    authenticationResult: [
      'authentication_result',
      optional(lazy(() => cardAuthenticationResponseSchema)),
    ],
    binDetails: ['bin_details', optional(lazy(() => binDetailsSchema))],
    type: ['type', optional(cardTypeSchema)],
  }
);
