/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { lazy, object, optional, Schema } from '../schema';
import {
  CardCustomerInformation,
  cardCustomerInformationSchema,
} from './cardCustomerInformation';
import { CardVerification, cardVerificationSchema } from './cardVerification';
import {
  VaultInstructionBase,
  vaultInstructionBaseSchema,
} from './vaultInstructionBase';

/** Additional attributes associated with the use of this card. */
export interface CardAttributes {
  /** The details about a customer in PayPal's system of record. */
  customer?: CardCustomerInformation;
  /** Basic vault instruction specification that can be extended by specific payment sources that supports vaulting. */
  vault?: VaultInstructionBase;
  /** The API caller can opt in to verify the card through PayPal offered verification services (e.g. Smart Dollar Auth, 3DS). */
  verification?: CardVerification;
}

export const cardAttributesSchema: Schema<CardAttributes> = object({
  customer: ['customer', optional(lazy(() => cardCustomerInformationSchema))],
  vault: ['vault', optional(lazy(() => vaultInstructionBaseSchema))],
  verification: ['verification', optional(lazy(() => cardVerificationSchema))],
});
