/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

import { array, lazy, object, optional, Schema, string } from '../schema';
import { DisbursementMode, disbursementModeSchema } from './disbursementMode';
import { PlatformFee, platformFeeSchema } from './platformFee';

/** Any additional payment instructions to be consider during payment processing. This processing instruction is applicable for Capturing an order or Authorizing an Order. */
export interface CapturePaymentInstruction {
  /** An array of platform or partner fees, commissions, or brokerage fees that associated with the captured payment. */
  platformFees?: PlatformFee[];
  /** The funds that are held on behalf of the merchant. */
  disbursementMode?: DisbursementMode;
  /** FX identifier generated returned by PayPal to be used for payment processing in order to honor FX rate (for eligible integrations) to be used when amount is settled/received into the payee account. */
  payeeReceivableFxRateId?: string;
}

export const capturePaymentInstructionSchema: Schema<CapturePaymentInstruction> = object(
  {
    platformFees: [
      'platform_fees',
      optional(array(lazy(() => platformFeeSchema))),
    ],
    disbursementMode: ['disbursement_mode', optional(disbursementModeSchema)],
    payeeReceivableFxRateId: [
      'payee_receivable_fx_rate_id',
      optional(string()),
    ],
  }
);
