/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { Schema } from '../schema';
import { AmountWithBreakdown } from './amountWithBreakdown';
import { Item } from './item';
import { ShippingOption } from './shippingOption';
/** This would contain shipping option and amount data at purchase unit level. */
export interface ShippingOptionsPurchaseUnit {
    /** The API caller-provided external ID for the purchase unit. Required for multiple purchase units when you must update the order through `PATCH`. If you omit this value and the order contains only one purchase unit, PayPal sets this value to `default`. Note: If there are multiple purchase units, reference_id is required for each purchase unit. */
    referenceId?: string;
    /** The total order amount with an optional breakdown that provides details, such as the total item amount, total tax amount, shipping, handling, insurance, and discounts, if any. If you specify `amount.breakdown`, the amount equals `item_total` plus `tax_total` plus `shipping` plus `handling` plus `insurance` minus `shipping_discount` minus discount. The amount must be a positive number. For listed of supported currencies and decimal precision, see the PayPal REST APIs Currency Codes. */
    amount?: AmountWithBreakdown;
    /** An array of items that the customer purchases from the merchant. */
    items?: Item[];
    /** An array of shipping options that the payee or merchant offers to the payer to ship or pick up their items. */
    shippingOptions?: ShippingOption[];
}
export declare const shippingOptionsPurchaseUnitSchema: Schema<ShippingOptionsPurchaseUnit>;
//# sourceMappingURL=shippingOptionsPurchaseUnit.d.ts.map