/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { Schema } from '../schema';
import { Address } from './address';
import { Name } from './name';
import { PaypalWalletAccountVerificationStatus } from './paypalWalletAccountVerificationStatus';
import { PaypalWalletAttributesResponse } from './paypalWalletAttributesResponse';
import { PaypalWalletStoredCredential } from './paypalWalletStoredCredential';
import { PhoneNumber } from './phoneNumber';
import { PhoneType } from './phoneType';
import { TaxInfo } from './taxInfo';
/** The PayPal Wallet response. */
export interface PaypalWalletResponse {
    /** The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters are allowed after the @ sign. However, the generally accepted maximum length for an email address is 254 characters. The pattern verifies that an unquoted @ sign exists. */
    emailAddress?: string;
    /** The PayPal payer ID, which is a masked version of the PayPal account number intended for use with third parties. The account number is reversibly encrypted and a proprietary variant of Base32 is used to encode the result. */
    accountId?: string;
    /** The account status indicates whether the buyer has verified the financial details associated with their PayPal account. */
    accountStatus?: PaypalWalletAccountVerificationStatus;
    /** The name of the party. */
    name?: Name;
    /** The phone type. */
    phoneType?: PhoneType;
    /** The phone number in its canonical international [E.164 numbering plan format](https://www.itu.int/rec/T-REC-E.164/en). */
    phoneNumber?: PhoneNumber;
    /** The stand-alone date, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.6). To represent special legal values, such as a date of birth, you should use dates with no associated time or time-zone data. Whenever possible, use the standard `date_time` type. This regular expression does not validate all dates. For example, February 31 is valid and nothing is known about leap years. */
    birthDate?: string;
    /** The business name of the PayPal account holder (populated for business accounts only) */
    businessName?: string;
    /** The tax ID of the customer. The customer is also known as the payer. Both `tax_id` and `tax_id_type` are required. */
    taxInfo?: TaxInfo;
    /** The portable international postal address. Maps to [AddressValidationMetadata](https://github.com/googlei18n/libaddressinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling form controls: the autocomplete attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-form-controls-the-autocomplete-attribute). */
    address?: Address;
    /** Additional attributes associated with the use of a PayPal Wallet. */
    attributes?: PaypalWalletAttributesResponse;
    /** Provides additional details to process a payment using the PayPal wallet billing agreement or a vaulted payment method that has been stored or is intended to be stored. */
    storedCredential?: PaypalWalletStoredCredential;
}
export declare const paypalWalletResponseSchema: Schema<PaypalWalletResponse>;
//# sourceMappingURL=paypalWalletResponse.d.ts.map