/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { Schema } from '../schema';
import { CallbackConfiguration } from './callbackConfiguration';
import { PayeePaymentMethodPreference } from './payeePaymentMethodPreference';
import { PaypalExperienceLandingPage } from './paypalExperienceLandingPage';
import { PaypalExperienceUserAction } from './paypalExperienceUserAction';
import { PaypalWalletContactPreference } from './paypalWalletContactPreference';
import { PaypalWalletContextShippingPreference } from './paypalWalletContextShippingPreference';
/** Customizes the payer experience during the approval process for payment with PayPal. Note: Partners and Marketplaces might configure brand_name and shipping_preference during partner account setup, which overrides the request values. */
export interface PaypalWalletExperienceContext {
    /** The label that overrides the business name in the PayPal account on the PayPal site. The pattern is defined by an external party and supports Unicode. */
    brandName?: string;
    /** The [language tag](https://tools.ietf.org/html/bcp47#section-2) for the language in which to localize the error-related strings, such as messages, issues, and suggested actions. The tag is made up of the [ISO 639-2 language code](https://www.loc.gov/standards/iso639-2/php/code_list.php), the optional [ISO-15924 script tag](https://www.unicode.org/iso15924/codelists.html), and the [ISO-3166 alpha-2 country code](/api/rest/reference/country-codes/) or [M49 region code](https://unstats.un.org/unsd/methodology/m49/). */
    locale?: string;
    /** The location from which the shipping address is derived. */
    shippingPreference?: PaypalWalletContextShippingPreference;
    /** The preference to display the contact information (buyer’s shipping email & phone number) on PayPal's checkout for easy merchant-buyer communication. */
    contactPreference?: PaypalWalletContactPreference;
    /** Describes the URL. */
    returnUrl?: string;
    /** Describes the URL. */
    cancelUrl?: string;
    /** The type of landing page to show on the PayPal site for customer checkout. */
    landingPage?: PaypalExperienceLandingPage;
    /** Configures a Continue or Pay Now checkout flow. */
    userAction?: PaypalExperienceUserAction;
    /** The merchant-preferred payment methods. */
    paymentMethodPreference?: PayeePaymentMethodPreference;
    /** CallBack Configuration that the merchant can provide to PayPal/Venmo. */
    orderUpdateCallbackConfig?: CallbackConfiguration;
}
export declare const paypalWalletExperienceContextSchema: Schema<PaypalWalletExperienceContext>;
//# sourceMappingURL=paypalWalletExperienceContext.d.ts.map