/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { Schema } from '../schema';
import { ApplePayRequest } from './applePayRequest';
import { BancontactPaymentRequest } from './bancontactPaymentRequest';
import { BlikPaymentRequest } from './blikPaymentRequest';
import { CardRequest } from './cardRequest';
import { EpsPaymentRequest } from './epsPaymentRequest';
import { GiropayPaymentRequest } from './giropayPaymentRequest';
import { GooglePayRequest } from './googlePayRequest';
import { IdealPaymentRequest } from './idealPaymentRequest';
import { MybankPaymentRequest } from './mybankPaymentRequest';
import { P24PaymentRequest } from './p24PaymentRequest';
import { PaypalWallet } from './paypalWallet';
import { SofortPaymentRequest } from './sofortPaymentRequest';
import { Token } from './token';
import { TrustlyPaymentRequest } from './trustlyPaymentRequest';
import { VenmoWalletRequest } from './venmoWalletRequest';
/** The payment source definition. */
export interface PaymentSource {
    /** The payment card to use to fund a payment. Can be a credit or debit card. Note: Passing card number, cvv and expiry directly via the API requires PCI SAQ D compliance. *PayPal offers a mechanism by which you do not have to take on the PCI SAQ D burden by using hosted fields - refer to this Integration Guide*. */
    card?: CardRequest;
    /** The tokenized payment source to fund a payment. */
    token?: Token;
    /** A resource that identifies a PayPal Wallet is used for payment. */
    paypal?: PaypalWallet;
    /** Information needed to pay using Bancontact. */
    bancontact?: BancontactPaymentRequest;
    /** Information needed to pay using BLIK. */
    blik?: BlikPaymentRequest;
    /** Information needed to pay using eps. */
    eps?: EpsPaymentRequest;
    /** Information needed to pay using giropay. */
    giropay?: GiropayPaymentRequest;
    /** Information needed to pay using iDEAL. */
    ideal?: IdealPaymentRequest;
    /** Information needed to pay using MyBank. */
    mybank?: MybankPaymentRequest;
    /** Information needed to pay using P24 (Przelewy24). */
    p24?: P24PaymentRequest;
    /** Information needed to pay using Sofort. */
    sofort?: SofortPaymentRequest;
    /** Information needed to pay using Trustly. */
    trustly?: TrustlyPaymentRequest;
    /** Information needed to pay using ApplePay. */
    applePay?: ApplePayRequest;
    /** Information needed to pay using Google Pay. */
    googlePay?: GooglePayRequest;
    /** Information needed to pay using Venmo. */
    venmo?: VenmoWalletRequest;
}
export declare const paymentSourceSchema: Schema<PaymentSource>;
//# sourceMappingURL=paymentSource.d.ts.map