/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { Schema } from '../schema';
import { EciFlag } from './eciFlag';
/** The Third Party Network token used to fund a payment. */
export interface NetworkToken {
    /** Third party network token number. */
    number: string;
    /** The year and month, in ISO-8601 `YYYY-MM` date format. See [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.6). */
    expiry: string;
    /** An Encrypted one-time use value that's sent along with Network Token. This field is not required to be present for recurring transactions. */
    cryptogram?: string;
    /** Electronic Commerce Indicator (ECI). The ECI value is part of the 2 data elements that indicate the transaction was processed electronically. This should be passed on the authorization transaction to the Gateway/Processor. */
    eciFlag?: EciFlag;
    /** A TRID, or a Token Requestor ID, is an identifier used by merchants to request network tokens from card networks. A TRID is a precursor to obtaining a network token for a credit card primary account number (PAN), and will aid in enabling secure card on file (COF) payments and reducing fraud. */
    tokenRequestorId?: string;
}
export declare const networkTokenSchema: Schema<NetworkToken>;
//# sourceMappingURL=networkToken.d.ts.map