/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
import { Schema } from '../schema';
import { BinDetails } from './binDetails';
import { CardAuthenticationResponse } from './cardAuthenticationResponse';
import { CardBrand } from './cardBrand';
import { CardResponseAddress } from './cardResponseAddress';
import { CardType } from './cardType';
import { CardVerificationDetails } from './cardVerificationDetails';
import { CardVerificationStatus } from './cardVerificationStatus';
import { NetworkTransactionReferenceEntity } from './networkTransactionReferenceEntity';
/** Full representation of a Card Payment Token. */
export interface CardPaymentTokenEntity {
    /** The card holder's name as it appears on the card. */
    name?: string;
    /** The last digits of the payment card. */
    lastDigits?: string;
    /** The card network or brand. Applies to credit, debit, gift, and payment cards. */
    brand?: CardBrand;
    /** The year and month, in ISO-8601 `YYYY-MM` date format. See [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.6). */
    expiry?: string;
    /** Address request details. */
    billingAddress?: CardResponseAddress;
    /** Verification status of Card. */
    verificationStatus?: CardVerificationStatus;
    /** Card Verification details including the authorization details and 3D SECURE details. */
    verification?: CardVerificationDetails;
    /** Previous network transaction reference including id in response. */
    networkTransactionReference?: NetworkTransactionReferenceEntity;
    /** Results of Authentication such as 3D Secure. */
    authenticationResult?: CardAuthenticationResponse;
    /** Bank Identification Number (BIN) details used to fund a payment. */
    binDetails?: BinDetails;
    /** Type of card. i.e Credit, Debit and so on. */
    type?: CardType;
}
export declare const cardPaymentTokenEntitySchema: Schema<CardPaymentTokenEntity>;
//# sourceMappingURL=cardPaymentTokenEntity.d.ts.map