"use strict";
/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
exports.__esModule = true;
exports.OrdersController = void 0;
var tslib_1 = require("tslib");
var confirmOrderRequest_1 = require("../models/confirmOrderRequest");
var order_1 = require("../models/order");
var orderAuthorizeRequest_1 = require("../models/orderAuthorizeRequest");
var orderAuthorizeResponse_1 = require("../models/orderAuthorizeResponse");
var orderCaptureRequest_1 = require("../models/orderCaptureRequest");
var orderRequest_1 = require("../models/orderRequest");
var orderTrackerRequest_1 = require("../models/orderTrackerRequest");
var patch_1 = require("../models/patch");
var schema_1 = require("../schema");
var baseController_1 = require("./baseController");
var customError_1 = require("../errors/customError");
var OrdersController = /** @class */ (function (_super) {
    tslib_1.__extends(OrdersController, _super);
    function OrdersController() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Updates an order with a `CREATED` or `APPROVED` status. You cannot update an order with the
     * `COMPLETED` status.<br/><br/>To make an update, you must provide a `reference_id`. If you omit this
     * value with an order that contains only one purchase unit, PayPal sets the value to `default` which
     * enables you to use the path: <code>\"/purchase_units/@reference_id=='default'/{attribute-or-
     * object}\"</code>. Merchants and partners can add Level 2 and 3 data to payments to reduce risk and
     * payment processing costs. For more information about processing payments, see <a href="https:
     * //developer.paypal.com/docs/checkout/advanced/processing/">checkout</a> or <a href="https:
     * //developer.paypal.com/docs/multiparty/checkout/advanced/processing/">multiparty checkout</a>.
     * <blockquote><strong>Note:</strong> For error handling and troubleshooting, see <a href="https:
     * //developer.paypal.com/api/rest/reference/orders/v2/errors/#patch-order">Orders v2 errors</a>.
     * </blockquote>Patchable attributes or objects:
     * <br/><br/><table><thead><th>Attribute</th><th>Op</th><th>Notes</th></thead><tbody><tr><td><code>inte
     * nt</code></td><td>replace</td><td></td></tr><tr><td><code>payer</code></td><td>replace,
     * add</td><td>Using replace op for <code>payer</code> will replace the whole <code>payer</code> object
     * with the value sent in request.</td></tr><tr><td><code>purchase_units</code></td><td>replace,
     * add</td><td></td></tr><tr><td><code>purchase_units[].custom_id</code></td><td>replace, add,
     * remove</td><td></td></tr><tr><td><code>purchase_units[].description</code></td><td>replace, add,
     * remove</td><td></td></tr><tr><td><code>purchase_units[].payee.
     * email</code></td><td>replace</td><td></td></tr><tr><td><code>purchase_units[].shipping.
     * name</code></td><td>replace, add</td><td></td></tr><tr><td><code>purchase_units[].shipping.
     * email_address</code></td><td>replace, add</td><td></td></tr><tr><td><code>purchase_units[].shipping.
     * phone_number</code></td><td>replace, add</td><td></td></tr><tr><td><code>purchase_units[].shipping.
     * options</code></td><td>replace, add</td><td></td></tr><tr><td><code>purchase_units[].shipping.
     * address</code></td><td>replace, add</td><td></td></tr><tr><td><code>purchase_units[].shipping.
     * type</code></td><td>replace, add</td><td></td></tr><tr><td><code>purchase_units[].
     * soft_descriptor</code></td><td>replace, remove</td><td></td></tr><tr><td><code>purchase_units[].
     * amount</code></td><td>replace</td><td></td></tr><tr><td><code>purchase_units[].
     * items</code></td><td>replace, add, remove</td><td></td></tr><tr><td><code>purchase_units[].
     * invoice_id</code></td><td>replace, add, remove</td><td></td></tr><tr><td><code>purchase_units[].
     * payment_instruction</code></td><td>replace</td><td></td></tr><tr><td><code>purchase_units[].
     * payment_instruction.disbursement_mode</code></td><td>replace</td><td>By default,
     * <code>disbursement_mode</code> is <code>INSTANT</code>.</td></tr><tr><td><code>purchase_units[].
     * payment_instruction.payee_receivable_fx_rate_id</code></td><td>replace, add,
     * remove</td><td></td></tr><tr><td><code>purchase_units[].payment_instruction.
     * platform_fees</code></td><td>replace, add, remove</td><td></td></tr><tr><td><code>purchase_units[].
     * supplementary_data.airline</code></td><td>replace, add,
     * remove</td><td></td></tr><tr><td><code>purchase_units[].supplementary_data.
     * card</code></td><td>replace, add, remove</td><td></td></tr><tr><td><code>application_context.
     * client_configuration</code></td><td>replace, add</td><td></td></tr></tbody></table>
     *
     * @param id                    The ID of the order to update.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative testing in the
     *                                         sandbox. This header configures the sandbox into a negative testing state
     *                                         for transactions that include the merchant.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that identifies the
     *                                         merchant. For details, see PayPal-Auth-Assertion.
     * @param body
     * @return Response from the API call
     */
    OrdersController.prototype.patchOrder = function (_a, requestOptions) {
        var id = _a.id, paypalMockResponse = _a.paypalMockResponse, paypalAuthAssertion = _a.paypalAuthAssertion, body = _a.body;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('PATCH');
                mapped = req.prepareArgs({
                    id: [id, (0, schema_1.string)()],
                    paypalMockResponse: [paypalMockResponse, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())],
                    body: [body, (0, schema_1.optional)((0, schema_1.array)(patch_1.patchSchema))]
                });
                req.header('Content-Type', 'application/json');
                req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.json(mapped.body);
                req.appendTemplatePath(templateObject_1 || (templateObject_1 = tslib_1.__makeTemplateObject(["/v2/checkout/orders/", ""], ["/v2/checkout/orders/", ""])), mapped.id);
                req.throwOn(400, customError_1.CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
                req.throwOn(401, customError_1.CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
                req.throwOn(404, customError_1.CustomError, 'The specified resource does not exist.');
                req.throwOn(422, customError_1.CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.call(requestOptions)];
            });
        });
    };
    /**
     * Authorizes payment for an order. To successfully authorize payment for an order, the buyer must
     * first approve the order or a valid payment_source must be provided in the request. A buyer can
     * approve the order upon being redirected to the rel:approve URL that was returned in the HATEOAS
     * links in the create order response. Note: For error handling and troubleshooting, see Orders v2
     * errors.
     *
     * @param id                        The ID of the order for which to authorize.
     * @param paypalMockResponse        PayPal's REST API uses a request header to
     *                                                                  invoke negative testing in the sandbox. This
     *                                                                  header configures the sandbox into a negative
     *                                                                  testing state for transactions that include the
     *                                                                  merchant.
     * @param paypalRequestId           The server stores keys for 6 hours. The API
     *                                                                  callers can request the times to up to 72 hours
     *                                                                  by speaking to their Account Manager. It is
     *                                                                  mandatory for all single-step create order calls
     *                                                                  (E.g. Create Order Request with payment source
     *                                                                  information like Card, PayPal.vault_id, PayPal.
     *                                                                  billing_agreement_id, etc).
     * @param prefer                    The preferred server response upon successful
     *                                                                  completion of the request. Value is:
     *                                                                  return=minimal. The server returns a minimal
     *                                                                  response to optimize communication between the
     *                                                                  API caller and the server. A minimal response
     *                                                                  includes the id, status and HATEOAS links.
     *                                                                  return=representation. The server returns a
     *                                                                  complete resource representation, including the
     *                                                                  current state of the resource.
     * @param paypalClientMetadataId
     * @param paypalAuthAssertion       An API-caller-provided JSON Web Token (JWT)
     *                                                                  assertion that identifies the merchant. For
     *                                                                  details, see PayPal-Auth-Assertion.
     * @param body
     * @return Response from the API call
     */
    OrdersController.prototype.authorizeOrder = function (_a, requestOptions) {
        var id = _a.id, paypalMockResponse = _a.paypalMockResponse, paypalRequestId = _a.paypalRequestId, prefer = _a.prefer, paypalClientMetadataId = _a.paypalClientMetadataId, paypalAuthAssertion = _a.paypalAuthAssertion, body = _a.body;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('POST');
                mapped = req.prepareArgs({
                    id: [id, (0, schema_1.string)()],
                    paypalMockResponse: [paypalMockResponse, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalRequestId: [paypalRequestId, (0, schema_1.optional)((0, schema_1.string)())],
                    prefer: [prefer, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalClientMetadataId: [paypalClientMetadataId, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())],
                    body: [body, (0, schema_1.optional)(orderAuthorizeRequest_1.orderAuthorizeRequestSchema)]
                });
                req.header('Content-Type', 'application/json');
                req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
                req.header('PayPal-Request-Id', mapped.paypalRequestId);
                req.header('Prefer', mapped.prefer);
                req.header('PayPal-Client-Metadata-Id', mapped.paypalClientMetadataId);
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.json(mapped.body);
                req.appendTemplatePath(templateObject_2 || (templateObject_2 = tslib_1.__makeTemplateObject(["/v2/checkout/orders/", "/authorize"], ["/v2/checkout/orders/", "/authorize"])), mapped.id);
                req.throwOn(400, customError_1.CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
                req.throwOn(401, customError_1.CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
                req.throwOn(403, customError_1.CustomError, 'The authorized payment failed due to insufficient permissions.');
                req.throwOn(404, customError_1.CustomError, 'The specified resource does not exist.');
                req.throwOn(422, customError_1.CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
                req.throwOn(500, customError_1.CustomError, 'An internal server error has occurred.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(orderAuthorizeResponse_1.orderAuthorizeResponseSchema, requestOptions)];
            });
        });
    };
    /**
     * Updates or cancels the tracking information for a PayPal order, by ID. Updatable attributes or
     * objects: Attribute Op Notes items replace Using replace op for items will replace the entire items
     * object with the value sent in request. notify_payer replace, add status replace Only patching status
     * to CANCELLED is currently supported.
     *
     * @param id                    The ID of the order that the tracking information is associated with.
     * @param trackerId             The order tracking ID.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that identifies the
     *                                         merchant. For details, see PayPal-Auth-Assertion.
     * @param body
     * @return Response from the API call
     */
    OrdersController.prototype.updateOrderTracking = function (_a, requestOptions) {
        var id = _a.id, trackerId = _a.trackerId, paypalAuthAssertion = _a.paypalAuthAssertion, body = _a.body;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('PATCH');
                mapped = req.prepareArgs({
                    id: [id, (0, schema_1.string)()],
                    trackerId: [trackerId, (0, schema_1.string)()],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())],
                    body: [body, (0, schema_1.optional)((0, schema_1.array)(patch_1.patchSchema))]
                });
                req.header('Content-Type', 'application/json');
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.json(mapped.body);
                req.appendTemplatePath(templateObject_3 || (templateObject_3 = tslib_1.__makeTemplateObject(["/v2/checkout/orders/", "/trackers/", ""], ["/v2/checkout/orders/", "/trackers/", ""])), mapped.id, mapped.trackerId);
                req.throwOn(400, customError_1.CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
                req.throwOn(403, customError_1.CustomError, 'Authorization failed due to insufficient permissions.');
                req.throwOn(404, customError_1.CustomError, 'The specified resource does not exist.');
                req.throwOn(422, customError_1.CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
                req.throwOn(500, customError_1.CustomError, 'An internal server error has occurred.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.call(requestOptions)];
            });
        });
    };
    /**
     * Adds tracking information for an Order.
     *
     * @param id                    The ID of the order that the tracking information is
     *                                                            associated with.
     * @param body
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion
     *                                                            that identifies the merchant. For details, see PayPal-
     *                                                            Auth-Assertion.
     * @return Response from the API call
     */
    OrdersController.prototype.createOrderTracking = function (_a, requestOptions) {
        var id = _a.id, body = _a.body, paypalAuthAssertion = _a.paypalAuthAssertion;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('POST');
                mapped = req.prepareArgs({
                    id: [id, (0, schema_1.string)()],
                    body: [body, orderTrackerRequest_1.orderTrackerRequestSchema],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())]
                });
                req.header('Content-Type', 'application/json');
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.json(mapped.body);
                req.appendTemplatePath(templateObject_4 || (templateObject_4 = tslib_1.__makeTemplateObject(["/v2/checkout/orders/", "/track"], ["/v2/checkout/orders/", "/track"])), mapped.id);
                req.throwOn(400, customError_1.CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
                req.throwOn(403, customError_1.CustomError, 'Authorization failed due to insufficient permissions.');
                req.throwOn(404, customError_1.CustomError, 'The specified resource does not exist.');
                req.throwOn(422, customError_1.CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
                req.throwOn(500, customError_1.CustomError, 'An internal server error has occurred.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(order_1.orderSchema, requestOptions)];
            });
        });
    };
    /**
     * Creates an order. Merchants and partners can add Level 2 and 3 data to payments to reduce risk and
     * payment processing costs. For more information about processing payments, see checkout or multiparty
     * checkout. Note: For error handling and troubleshooting, see Orders v2 errors.
     *
     * @param body
     * @param paypalMockResponse            PayPal's REST API uses a request header to invoke
     *                                                             negative testing in the sandbox. This header
     *                                                             configures the sandbox into a negative testing state
     *                                                             for transactions that include the merchant.
     * @param paypalRequestId               The server stores keys for 6 hours. The API callers
     *                                                             can request the times to up to 72 hours by speaking to
     *                                                             their Account Manager. It is mandatory for all single-
     *                                                             step create order calls (E.g. Create Order Request
     *                                                             with payment source information like Card, PayPal.
     *                                                             vault_id, PayPal.billing_agreement_id, etc).
     * @param paypalPartnerAttributionId
     * @param paypalClientMetadataId
     * @param prefer                        The preferred server response upon successful
     *                                                             completion of the request. Value is: return=minimal.
     *                                                             The server returns a minimal response to optimize
     *                                                             communication between the API caller and the server. A
     *                                                             minimal response includes the id, status and HATEOAS
     *                                                             links. return=representation. The server returns a
     *                                                             complete resource representation, including the
     *                                                             current state of the resource.
     * @param paypalAuthAssertion           An API-caller-provided JSON Web Token (JWT) assertion
     *                                                             that identifies the merchant. For details, see PayPal-
     *                                                             Auth-Assertion.
     * @return Response from the API call
     */
    OrdersController.prototype.createOrder = function (_a, requestOptions) {
        var body = _a.body, paypalMockResponse = _a.paypalMockResponse, paypalRequestId = _a.paypalRequestId, paypalPartnerAttributionId = _a.paypalPartnerAttributionId, paypalClientMetadataId = _a.paypalClientMetadataId, prefer = _a.prefer, paypalAuthAssertion = _a.paypalAuthAssertion;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('POST', '/v2/checkout/orders');
                mapped = req.prepareArgs({
                    body: [body, orderRequest_1.orderRequestSchema],
                    paypalMockResponse: [paypalMockResponse, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalRequestId: [paypalRequestId, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalPartnerAttributionId: [
                        paypalPartnerAttributionId,
                        (0, schema_1.optional)((0, schema_1.string)()),
                    ],
                    paypalClientMetadataId: [paypalClientMetadataId, (0, schema_1.optional)((0, schema_1.string)())],
                    prefer: [prefer, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())]
                });
                req.header('Content-Type', 'application/json');
                req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
                req.header('PayPal-Request-Id', mapped.paypalRequestId);
                req.header('PayPal-Partner-Attribution-Id', mapped.paypalPartnerAttributionId);
                req.header('PayPal-Client-Metadata-Id', mapped.paypalClientMetadataId);
                req.header('Prefer', mapped.prefer);
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.json(mapped.body);
                req.throwOn(400, customError_1.CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
                req.throwOn(401, customError_1.CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
                req.throwOn(422, customError_1.CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(order_1.orderSchema, requestOptions)];
            });
        });
    };
    /**
     * Captures payment for an order. To successfully capture payment for an order, the buyer must first
     * approve the order or a valid payment_source must be provided in the request. A buyer can approve the
     * order upon being redirected to the rel:approve URL that was returned in the HATEOAS links in the
     * create order response. Note: For error handling and troubleshooting, see Orders v2 errors.
     *
     * @param id                        The ID of the order for which to capture a payment.
     * @param paypalMockResponse        PayPal's REST API uses a request header to invoke
     *                                                                negative testing in the sandbox. This header
     *                                                                configures the sandbox into a negative testing
     *                                                                state for transactions that include the merchant.
     * @param paypalRequestId           The server stores keys for 6 hours. The API
     *                                                                callers can request the times to up to 72 hours by
     *                                                                speaking to their Account Manager. It is mandatory
     *                                                                for all single-step create order calls (E.g. Create
     *                                                                Order Request with payment source information like
     *                                                                Card, PayPal.vault_id, PayPal.billing_agreement_id,
     *                                                                etc).
     * @param prefer                    The preferred server response upon successful
     *                                                                completion of the request. Value is: return=minimal.
     *                                                                The server returns a minimal response to optimize
     *                                                                communication between the API caller and the server.
     *                                                                A minimal response includes the id, status and
     *                                                                HATEOAS links. return=representation. The server
     *                                                                returns a complete resource representation,
     *                                                                including the current state of the resource.
     * @param paypalClientMetadataId
     * @param paypalAuthAssertion       An API-caller-provided JSON Web Token (JWT)
     *                                                                assertion that identifies the merchant. For details,
     *                                                                see PayPal-Auth-Assertion.
     * @param body
     * @return Response from the API call
     */
    OrdersController.prototype.captureOrder = function (_a, requestOptions) {
        var id = _a.id, paypalMockResponse = _a.paypalMockResponse, paypalRequestId = _a.paypalRequestId, prefer = _a.prefer, paypalClientMetadataId = _a.paypalClientMetadataId, paypalAuthAssertion = _a.paypalAuthAssertion, body = _a.body;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('POST');
                mapped = req.prepareArgs({
                    id: [id, (0, schema_1.string)()],
                    paypalMockResponse: [paypalMockResponse, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalRequestId: [paypalRequestId, (0, schema_1.optional)((0, schema_1.string)())],
                    prefer: [prefer, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalClientMetadataId: [paypalClientMetadataId, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())],
                    body: [body, (0, schema_1.optional)(orderCaptureRequest_1.orderCaptureRequestSchema)]
                });
                req.header('Content-Type', 'application/json');
                req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
                req.header('PayPal-Request-Id', mapped.paypalRequestId);
                req.header('Prefer', mapped.prefer);
                req.header('PayPal-Client-Metadata-Id', mapped.paypalClientMetadataId);
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.json(mapped.body);
                req.appendTemplatePath(templateObject_5 || (templateObject_5 = tslib_1.__makeTemplateObject(["/v2/checkout/orders/", "/capture"], ["/v2/checkout/orders/", "/capture"])), mapped.id);
                req.throwOn(400, customError_1.CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
                req.throwOn(401, customError_1.CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
                req.throwOn(403, customError_1.CustomError, 'The authorized payment failed due to insufficient permissions.');
                req.throwOn(404, customError_1.CustomError, 'The specified resource does not exist.');
                req.throwOn(422, customError_1.CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
                req.throwOn(500, customError_1.CustomError, 'An internal server error has occurred.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(order_1.orderSchema, requestOptions)];
            });
        });
    };
    /**
     * Shows details for an order, by ID. Note: For error handling and troubleshooting, see Orders v2
     * errors.
     *
     * @param id                    The ID of the order for which to show details.
     * @param paypalMockResponse    PayPal's REST API uses a request header to invoke negative testing in the
     *                                        sandbox. This header configures the sandbox into a negative testing state
     *                                        for transactions that include the merchant.
     * @param paypalAuthAssertion   An API-caller-provided JSON Web Token (JWT) assertion that identifies the
     *                                        merchant. For details, see PayPal-Auth-Assertion.
     * @param fields                A comma-separated list of fields that should be returned for the order.
     *                                        Valid filter field is `payment_source`.
     * @return Response from the API call
     */
    OrdersController.prototype.getOrder = function (_a, requestOptions) {
        var id = _a.id, paypalMockResponse = _a.paypalMockResponse, paypalAuthAssertion = _a.paypalAuthAssertion, fields = _a.fields;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('GET');
                mapped = req.prepareArgs({
                    id: [id, (0, schema_1.string)()],
                    paypalMockResponse: [paypalMockResponse, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())],
                    fields: [fields, (0, schema_1.optional)((0, schema_1.string)())]
                });
                req.header('PayPal-Mock-Response', mapped.paypalMockResponse);
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.query('fields', mapped.fields);
                req.appendTemplatePath(templateObject_6 || (templateObject_6 = tslib_1.__makeTemplateObject(["/v2/checkout/orders/", ""], ["/v2/checkout/orders/", ""])), mapped.id);
                req.throwOn(401, customError_1.CustomError, 'Authentication failed due to missing authorization header, or invalid authentication credentials.');
                req.throwOn(404, customError_1.CustomError, 'The specified resource does not exist.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(order_1.orderSchema, requestOptions)];
            });
        });
    };
    /**
     * Payer confirms their intent to pay for the the Order with the given payment source.
     *
     * @param id                        The ID of the order for which the payer confirms
     *                                                                their intent to pay.
     * @param paypalClientMetadataId
     * @param paypalAuthAssertion       An API-caller-provided JSON Web Token (JWT)
     *                                                                assertion that identifies the merchant. For details,
     *                                                                see PayPal-Auth-Assertion.
     * @param prefer                    The preferred server response upon successful
     *                                                                completion of the request. Value is: return=minimal.
     *                                                                The server returns a minimal response to optimize
     *                                                                communication between the API caller and the server.
     *                                                                A minimal response includes the id, status and
     *                                                                HATEOAS links. return=representation. The server
     *                                                                returns a complete resource representation,
     *                                                                including the current state of the resource.
     * @param body
     * @return Response from the API call
     */
    OrdersController.prototype.confirmOrder = function (_a, requestOptions) {
        var id = _a.id, paypalClientMetadataId = _a.paypalClientMetadataId, paypalAuthAssertion = _a.paypalAuthAssertion, prefer = _a.prefer, body = _a.body;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('POST');
                mapped = req.prepareArgs({
                    id: [id, (0, schema_1.string)()],
                    paypalClientMetadataId: [paypalClientMetadataId, (0, schema_1.optional)((0, schema_1.string)())],
                    paypalAuthAssertion: [paypalAuthAssertion, (0, schema_1.optional)((0, schema_1.string)())],
                    prefer: [prefer, (0, schema_1.optional)((0, schema_1.string)())],
                    body: [body, (0, schema_1.optional)(confirmOrderRequest_1.confirmOrderRequestSchema)]
                });
                req.header('Content-Type', 'application/json');
                req.header('PayPal-Client-Metadata-Id', mapped.paypalClientMetadataId);
                req.header('PayPal-Auth-Assertion', mapped.paypalAuthAssertion);
                req.header('Prefer', mapped.prefer);
                req.json(mapped.body);
                req.appendTemplatePath(templateObject_7 || (templateObject_7 = tslib_1.__makeTemplateObject(["/v2/checkout/orders/", "/confirm-payment-source"], ["/v2/checkout/orders/", "/confirm-payment-source"])), mapped.id);
                req.throwOn(400, customError_1.CustomError, 'Request is not well-formed, syntactically incorrect, or violates schema.');
                req.throwOn(403, customError_1.CustomError, 'Authorization failed due to insufficient permissions.');
                req.throwOn(422, customError_1.CustomError, 'The requested action could not be performed, semantically incorrect, or failed business validation.');
                req.throwOn(500, customError_1.CustomError, 'An internal server error has occurred.');
                req.defaultToError(customError_1.CustomError, 'The error response.');
                req.authenticate([{ oauth2: true }]);
                return [2 /*return*/, req.callAsJson(order_1.orderSchema, requestOptions)];
            });
        });
    };
    return OrdersController;
}(baseController_1.BaseController));
exports.OrdersController = OrdersController;
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5, templateObject_6, templateObject_7;
//# sourceMappingURL=ordersController.js.map