"use strict";
/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
exports.__esModule = true;
exports.OAuthAuthorizationController = void 0;
var tslib_1 = require("tslib");
var oAuthToken_1 = require("../models/oAuthToken");
var schema_1 = require("../schema");
var baseController_1 = require("./baseController");
var oAuthProviderError_1 = require("../errors/oAuthProviderError");
var OAuthAuthorizationController = /** @class */ (function (_super) {
    tslib_1.__extends(OAuthAuthorizationController, _super);
    function OAuthAuthorizationController() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Create a new OAuth 2 token.
     *
     * @param authorization Authorization header in Basic auth format
     * @param scope         Requested scopes as a space-delimited list.
     * @return Response from the API call
     */
    OAuthAuthorizationController.prototype.requestToken = function (_a, fieldParameters, requestOptions) {
        var authorization = _a.authorization, scope = _a.scope;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var req, mapped;
            return tslib_1.__generator(this, function (_b) {
                req = this.createRequest('POST', '/v1/oauth2/token');
                mapped = req.prepareArgs({
                    authorization: [authorization, (0, schema_1.string)()],
                    scope: [scope, (0, schema_1.optional)((0, schema_1.string)())]
                });
                req.header('Authorization', mapped.authorization);
                req.form(tslib_1.__assign({ grant_type: 'client_credentials', scope: mapped.scope }, fieldParameters));
                req.throwOn(400, oAuthProviderError_1.OAuthProviderError, 'OAuth 2 provider returned an error.');
                req.throwOn(401, oAuthProviderError_1.OAuthProviderError, 'OAuth 2 provider says client authentication failed.');
                req.authenticate(false);
                return [2 /*return*/, req.callAsJson(oAuthToken_1.oAuthTokenSchema, requestOptions)];
            });
        });
    };
    return OAuthAuthorizationController;
}(baseController_1.BaseController));
exports.OAuthAuthorizationController = OAuthAuthorizationController;
//# sourceMappingURL=oAuthAuthorizationController.js.map