"use strict";
/**
 * PayPal Server SDKLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */
exports.__esModule = true;
exports.Client = void 0;
var tslib_1 = require("tslib");
var authProvider_1 = require("./authProvider");
var clientCredentialsAuthManager_1 = require("./clientCredentialsAuthManager");
var configuration_1 = require("./configuration");
var defaultConfiguration_1 = require("./defaultConfiguration");
var core_1 = require("./core");
var core_2 = require("./core");
var core_3 = require("./core");
var core_4 = require("./core");
var core_5 = require("./core");
var clientAdapter_1 = require("./clientAdapter");
var Client = /** @class */ (function () {
    function Client(config) {
        var _this = this;
        var _a, _b, _c, _d, _e, _f;
        this._config = tslib_1.__assign(tslib_1.__assign({}, defaultConfiguration_1.DEFAULT_CONFIGURATION), config);
        this._retryConfig = tslib_1.__assign(tslib_1.__assign({}, defaultConfiguration_1.DEFAULT_RETRY_CONFIG), (_a = this._config.httpClientOptions) === null || _a === void 0 ? void 0 : _a.retryConfig);
        this._loggingOp = this._config.logging
            ? (0, core_1.mergeLoggingOptions)((_b = this._config.logging) !== null && _b !== void 0 ? _b : {})
            : (0, core_1.mergeLoggingOptions)((_c = this._config.logging) !== null && _c !== void 0 ? _c : {}, defaultConfiguration_1.DEFAULT_LOGGING_OPTIONS);
        this._timeout =
            typeof ((_d = this._config.httpClientOptions) === null || _d === void 0 ? void 0 : _d.timeout) != 'undefined'
                ? this._config.httpClientOptions.timeout
                : this._config.timeout;
        var clonedConfig = tslib_1.__assign(tslib_1.__assign({}, this._config), { clientCredentialsAuthCredentials: this._config
                .clientCredentialsAuthCredentials || {
                oAuthClientId: '',
                oAuthClientSecret: ''
            } });
        this._userAgent = (0, core_4.updateUserAgent)('PayPal REST API TypeScript SDK, Version: 1.1.0, on OS {os-info}');
        this._requestBuilderFactory = createRequestHandlerFactory(function (server) { return getBaseUri(server, _this._config); }, (0, authProvider_1.createAuthProviderFromConfig)(this._config, function () { return _this.clientCredentialsAuthManager; }), new clientAdapter_1.HttpClient(core_5.AbortError, {
            timeout: this._timeout,
            clientConfigOverrides: this._config.unstable_httpClientOptions,
            httpAgent: (_e = this._config.httpClientOptions) === null || _e === void 0 ? void 0 : _e.httpAgent,
            httpsAgent: (_f = this._config.httpClientOptions) === null || _f === void 0 ? void 0 : _f.httpsAgent
        }), [
            withErrorHandlers,
            withUserAgent(this._userAgent),
            withAuthenticationByDefault,
        ], this._retryConfig, this._loggingOp);
        this.clientCredentialsAuthManager = new clientCredentialsAuthManager_1.ClientCredentialsAuthManager(clonedConfig.clientCredentialsAuthCredentials, this);
    }
    Client.prototype.getRequestBuilderFactory = function () {
        return this._requestBuilderFactory;
    };
    /**
     * Clone this client and override given configuration options
     */
    Client.prototype.withConfiguration = function (config) {
        return new Client(tslib_1.__assign(tslib_1.__assign({}, this._config), config));
    };
    return Client;
}());
exports.Client = Client;
function createHttpClientAdapter(client) {
    var _this = this;
    return function (request, requestOptions) { return tslib_1.__awaiter(_this, void 0, void 0, function () {
        return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, client.executeRequest(request, requestOptions)];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    }); };
}
function getBaseUri(server, config) {
    if (server === void 0) { server = 'default'; }
    if (config.environment === configuration_1.Environment.Production) {
        if (server === 'default') {
            return 'https://api-m.paypal.com';
        }
    }
    if (config.environment === configuration_1.Environment.Sandbox) {
        if (server === 'default') {
            return 'https://api-m.sandbox.paypal.com';
        }
    }
    throw new Error('Could not get Base URL. Invalid environment or server.');
}
function createRequestHandlerFactory(baseUrlProvider, authProvider, httpClient, addons, retryConfig, loggingOptions) {
    var requestBuilderFactory = (0, core_5.createRequestBuilderFactory)(createHttpClientAdapter(httpClient), baseUrlProvider, core_2.ApiError, authProvider, retryConfig, undefined, new core_1.ApiLogger(loggingOptions));
    return tap.apply(void 0, tslib_1.__spreadArray([requestBuilderFactory], addons, false));
}
function tap(requestBuilderFactory) {
    var callback = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        callback[_i - 1] = arguments[_i];
    }
    return function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var requestBuilder = requestBuilderFactory.apply(void 0, args);
        callback.forEach(function (c) { return c(requestBuilder); });
        return requestBuilder;
    };
}
function withErrorHandlers(rb) {
    rb.defaultToError(core_2.ApiError);
}
function withUserAgent(userAgent) {
    return function (rb) {
        rb.interceptRequest(function (request) {
            var _a;
            var headers = (_a = request.headers) !== null && _a !== void 0 ? _a : {};
            (0, core_3.setHeader)(headers, 'user-agent', userAgent);
            return tslib_1.__assign(tslib_1.__assign({}, request), { headers: headers });
        });
    };
}
function withAuthenticationByDefault(rb) {
    rb.authenticate([]);
}
//# sourceMappingURL=client.js.map